<?php

include_once 'include/Webservices/VtigerModuleOperation.php';
include_once 'include/Webservices/Query.php';


class MYCModuleOperation extends VtigerModuleOperation{
	

	public function MYCrelatedIds($id, $relatedModule, $relatedLabel, $relatedHandler=null) {
		$ids = vtws_getIdComponents($id);
        $sourceModule = $this->webserviceObject->getEntityName();		
        global $currentModule;
        $currentModule = $sourceModule;
		$sourceRecordModel = Vtiger_Record_Model::getInstanceById($ids[1], $sourceModule);
		$targetModel       = Vtiger_RelationListView_Model::getInstance($sourceRecordModel, $relatedModule, $relatedLabel);
        $sql = $targetModel->getRelationQuery();

        $relatedWebserviceObject = VtigerWebserviceObject::fromName($adb,$relatedModule);
        $relatedModuleWSId = $relatedWebserviceObject->getEntityId();

		// Rewrite query to pull only crmid transformed as webservice id.
        $sqlFromPart = substr($sql, stripos($sql, ' FROM ')+6);        
        $sql = sprintf("SELECT DISTINCT concat('%sx',vtiger_crmentity.crmid) as wsid FROM %s", $relatedModuleWSId, $sqlFromPart);
                
        $rs = $this->pearDB->pquery($sql, array());
        $relatedIds = array();
		while ($row = $this->pearDB->fetch_array($rs)) {
            $relatedIds[] = $row['wsid'];
		}
		return $relatedIds;
    }
    
}

function myc_retrieve_related($id, $relatedType, $relatedLabel, $user) {
    $query = 'SELECT * FROM ' . $relatedType;
    return myc_query_related($query, $id, $relatedLabel, $user);
}

function myc_query_related($query, $id, $relatedLabel, $user, $filterClause = null) {
    global $log, $adb;

    $webserviceObject = VtigerWebserviceObject::fromId($adb, $id);
    $handler = new MYCModuleOperation($webserviceObject, $user, $adb, $log);
    $meta = $handler->getMeta();
    $entityName = $meta->getObjectEntityName($id);

	// Extract related module name from query.
    $relatedType = null;
    if (preg_match("/FROM\s+([^\s]+)/i", $query, $m)) {
	    $relatedType = trim($m[1]);
    }
   
    // Check for presence of expected relation.
    $found = false;
    $relatedTypes = myc_relatedtypes($entityName, $user);

    foreach ($relatedTypes['information'] as $label => $information) {
        if ($label == $relatedLabel && $information['name'] == $relatedType) {
            $found = true;
            break;
        }
    }

    if (!$found) {
        throw new WebServiceException(WebServiceErrorCode::$UNKOWNENTITY, "Relation specified is incorrect");
    }
    
    
    
    vtws_preserveGlobal('currentModule', $entityName);

	// Fetch related record IDs - so we can further retrieve complete information using vtws_query 
    $relatedWebserviceObject = VtigerWebserviceObject::fromName($adb, $relatedType);
    $relatedHandler = new MYCModuleOperation($relatedWebserviceObject, $user, $adb, $log);
    
    
    
    $relatedIds = $handler->MYCrelatedIds($id, $relatedType, $relatedLabel, $relatedHandler);
    //return $relatedHandlerClass."tttt";

	// Initialize return value
	$relatedRecords = array();
	
	// Rewrite query and extract related records if there at least one.
    if (!empty($relatedIds)) {    	
        $relatedIdClause = "id IN ('".implode("','", $relatedIds)."')";
        if (stripos($query, 'WHERE') == false) {
            $query .= " WHERE " . $relatedIdClause;
        } else {
            $queryParts = explode('WHERE', $query);
            $query = $queryParts[0] ." WHERE " . $relatedIdClause;
            $query .= " AND " .$queryParts[1];
        }
        if(!empty($filterClause)){
            $query .= " " . $filterClause;
        }
        $query.=";";
        $relatedRecords = vtws_query($query, $user);
    }

	VTWS_PreserveGlobal::flush();	
    return $relatedRecords;
}

function myc_relatedtypes($elementType, $user) {
    global $adb, $log;

    $allowedTypes = vtws_listtypes(null, $user);

    $webserviceObject = VtigerWebserviceObject::fromName($adb, $elementType);
    $handlerPath  = $webserviceObject->getHandlerPath();
    $handlerClass = $webserviceObject->getHandlerClass();

    require_once $handlerPath;
    $handler = new $handlerClass($webserviceObject, $user, $adb, $log);
    $meta = $handler->getMeta();
    $tabid = $meta->getTabId();

    $sql = "SELECT vtiger_relatedlists.label, vtiger_tab.name, vtiger_tab.isentitytype FROM vtiger_relatedlists 
            INNER JOIN vtiger_tab ON vtiger_tab.tabid=vtiger_relatedlists.related_tabid 
            WHERE vtiger_relatedlists.tabid=? AND vtiger_tab.presence = 0";

    $params = array($tabid);
    $rs = $adb->pquery($sql, $params);

    $return = array('types' => array(), 'information' => array());

    while ($row = $adb->fetch_array($rs)) {
        if (in_array($row['name'], $allowedTypes['types'])) {
            $return['types'][] = $row['name'];
            // There can be same module related under different label - so label is our key.
            $return['information'][$row['label']] = array(
                'name' => $row['name'],
                'label'=> $row['label'],
                'isEntity' => $row['isentitytype']
            );
        }
    }

	return $return;
}

?>