<?php

/*************************************************************************************************
 * Copyright 2012-2014 JPL TSolucio, S.L.  --  This file is a part of coreBOSCP.
* You can copy, adapt and distribute the work under the "Attribution-NonCommercial-ShareAlike"
* Vizsage Public License (the "License"). You may not use this file except in compliance with the
* License. Roughly speaking, non-commercial users may share and modify this code, but must give credit
* and share improvements. However, for proper details please read the full License, available at
* http://vizsage.com/license/Vizsage-License-BY-NC-SA.html and the handy reference for understanding
* the full license at http://vizsage.com/license/Vizsage-Deed-BY-NC-SA.html. Unless required by
* applicable law or agreed to in writing, any software distributed under the License is distributed
* on an  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and limitations under the
* License terms of Creative Commons Attribution-NonCommercial-ShareAlike 3.0 (the License).
*************************************************************************************************/
include_once 'vtlib/Vtiger/Module.php';
include_once 'vtlib/Vtiger/Functions.php';
include_once 'includes/main/WebUI.php';

include_once 'include/Webservices/AuthToken.php';
require_once('modules/Emails/mail.php');
require_once 'modules/Users/Users.php';

ini_set("display_errors","Off"); error_reporting(E_ERROR);

	function myc_loginportal($username,$password) {
		
		global $adb, $log;
		$log->debug('Entering LoginPortal function with parameter username: '.$username);
		
		$ctors = $adb->pquery('select *
			from vtiger_portalinfo
			inner join vtiger_customerdetails on vtiger_portalinfo.id=vtiger_customerdetails.customerid
			inner join vtiger_crmentity on vtiger_crmentity.crmid=vtiger_portalinfo.id
			where vtiger_crmentity.deleted=0 and user_name=? 
			  and isactive=1 and vtiger_customerdetails.portal=1',array($username));
					  
			  
		if ($ctors and $adb->num_rows($ctors)==1) {
//return array("pt"=>Vtiger_Functions::compareEncryptedPassword($password, $adb->query_result($ctors, 0, 'user_password'), $adb->query_result($ctors, 0, 'cryptmode')),"pm"=>$adb->query_result($ctors, 0, 'cryptmode'), "up"=>$adb->query_result($ctors, 0, 'user_password') , "pss"=>$password);
				$cryptmode = $adb->query_result($ctors, 0, 'cryptmode');
				if(!isset($cryptmode) || $cryptmode=="") $cryptmode = "PLAIN";
				
				if (myc_compareEncryptedPassword($password, $adb->query_result($ctors, 0, 'user_password'), $cryptmode)) {
					
					$result = $adb->query("SELECT id FROM vtiger_ws_entity WHERE name = 'Contacts'");
					$ctowsid = $adb->query_result($result,0,'id');
					$ctocmrid = $adb->query_result($ctors,0,'id');
					$accessinfo= array();
					$accessinfo['user'] = array(
						'contactid' => $ctowsid.'x'.$ctocmrid,
					);
					return $accessinfo;
					
				} 
				else throw new WebServiceException(WebServiceErrorCode::$AUTHREQUIRED,"Given password is wrong".$username);
										
		}
		throw new WebServiceException(WebServiceErrorCode::$AUTHREQUIRED,"Given contact is inactive: ".$username);
	}
	
	function myc_translate($string){
		
			
		global $default_language;
		
		$languageStrings=array();
		
		if(file_exists(__DIR__."/../../../languages/".$default_language."/MYCExtendedWebServices.php"))
			include __DIR__."/../../../languages/".$default_language."/MYCExtendedWebServices.php";
		
		if(isset($languageStrings[$string]))
			return $languageStrings[$string];
			
		else return $string;
		
	}
	
	function myc_sendEmail($to,$subject,$content){
		
		/** Configure language for server response translation */
		global $default_language, $current_language;
		if(!isset($current_language)) $current_language = $default_language;

		global $adb,$mod_strings,$log;
		
		$mail = new PHPMailer();
	
		$mail->Subject =  $subject;
		$mail->Body    = $content;
		$mail->IsSMTP();
		
				
		$fromquery = "select vtiger_users.user_name, vtiger_users.email1 from vtiger_users inner join vtiger_crmentity on vtiger_users.id = vtiger_crmentity.smownerid inner join vtiger_contactdetails on vtiger_contactdetails.contactid=vtiger_crmentity.crmid where vtiger_contactdetails.email =?";
		$from_res = $adb->pquery($fromquery, array($to));
		$initialfrom = $adb->query_result($from_res,0,'user_name');
		$from = $adb->query_result($from_res,0,'email1');
		$replyto = $from;
		
		if(!isset($from) || $from==""){
			require "config.inc.php";
			$from = $HELPDESK_SUPPORT_EMAIL_ID;
			$initialfrom = $HELPDESK_SUPPORT_NAME;
			$replyto = $HELPDESK_SUPPORT_EMAIL_REPLY_ID;
		}
		
		$mailserverresult = $adb->pquery("select * from vtiger_systems where server_type=?", array('email'));
		$mail_server = $adb->query_result($mailserverresult,0,'server');
		$mail_server_username = $adb->query_result($mailserverresult,0,'server_username');
		$mail_server_password = $adb->query_result($mailserverresult,0,'server_password');
		$smtp_auth = $adb->query_result($mailserverresult,0,'smtp_auth');
	
		$mail->Host = $mail_server;
		if($smtp_auth) 
		$mail->SMTPAuth = 'true';
		$mail->Username = $mail_server_username;
		$mail->Password = $mail_server_password;
		$mail->From = $from;
		$mail->FromName = $initialfrom;
	
		
		$mail->AddAddress($to);
		$mail->AddReplyTo($replyto);
		$mail->WordWrap = 50;
		$mail->IsHTML(true);
	
		$mail->AltBody = $mod_strings['LBL_ALTBODY'];
		
		if(!$mail->Send()){
			
			$nln = "\r\n";
			$headers = "From: ".$initialfrom." <".$from.">\r\n"
			."Reply-To: ".$from."\r\n"
			."MIME-Version: 1.0\r\n"
			."Content-Type: text/html; charset=UTF-8";
			
			
			if(!mail($to, $mail->Subject, $mail->Body, $headers)){	
				$ret_msg = "false@@@<b>LBL_MAIL_COULDNOT_SENT-".myc_translate('LBL_MAIL_COULDNOT_SENT')."</b>";
				return array("result"=>"error","error"=>$ret_msg);
			}
			else $ret_msg = "true@@@<b>LBL_MAIL_SENT 1</b>";
		}
		
		else $ret_msg = "true@@@<b>LBL_MAIL_SENT 0</b>";
		return $ret_msg;
	}
	
	function myc_reset_password($username)
	{
		
				
		/** Configure language for server response translation */
		global $default_language, $current_language;
		if(!isset($current_language)) $current_language = $default_language;

		global $adb,$mod_strings,$log;
		$log->debug("Entering customer portal function send_mail_for_password");
		$adb->println("Inside the function send_mail_for_password($username).");
	
		$sql = "select * from vtiger_portalinfo  where user_name = ? ";
		$res = $adb->pquery($sql, array($username));
		$user_name = $adb->query_result($res,0,'user_name');
		$password = $adb->query_result($res,0,'user_password');
		$isactive = $adb->query_result($res,0,'isactive');
		$cryptmode = $adb->query_result($res,0,'cryptmode');
		
		//CREATE NEW RANDOM PASSWORD
		$newpassword = generateStrongPassword();
		
		
		
		if(isset($cryptmode) && $cryptmode!=""){
			$sql = "update vtiger_portalinfo set user_password=?, cryptmode=? where user_name=?";
			$result = $adb->pquery($sql, array(myc_generateEncryptedPassword($newpassword), 'CRYPT', $username));
		}
		else {
			$sql = "update vtiger_portalinfo set user_password=? where user_name=?";
			$result = $adb->pquery($sql, array($newpassword, $username));
		}
		
	
		$contents = myc_translate('LBL_LOGIN_DETAILS');
		$contents .= "<br><br>Username: ".$user_name;
		$contents .= "<br>Password: ".$newpassword;
		//$contents .= "<br>Crypt: ".$cryptmode;
	
		$subject =  myc_translate('LBL_SUBJECT_PORTAL_LOGIN_DETAILS');
			
		if($username == '')
		{
			$ret_msg = "false@@@<b>LBL_GIVE_MAILID-".myc_translate('LBL_GIVE_MAILID')."</b>";
			return array("result"=>"error","error"=>$ret_msg);
		}
		elseif($user_name == '')
		{
			$ret_msg = "false@@@<b>LBL_CHECK_MAILID-".myc_translate('LBL_CHECK_MAILID')."</b>";
			return array("result"=>"error","error"=>$ret_msg);
		}
		elseif($isactive == 0)
		{
			$ret_msg = "false@@@<b>LBL_LOGIN_REVOKED-".myc_translate('LBL_LOGIN_REVOKED')."</b>";
			return array("result"=>"error","error"=>$ret_msg);
		}
		else
		{
			$ret_msg = myc_sendEmail($user_name,$subject,$contents);
		}
	
		$adb->println("Exit from send_mail_for_password. $ret_msg");
		$log->debug("Exiting customer portal function send_mail_for_password");
		return array("result"=>"success");
	}
	
	
	function myc_change_password($username,$newpassword)
	{
		
				
		/** Configure language for server response translation */
		global $default_language, $current_language;
		if(!isset($current_language)) $current_language = $default_language;

		global $adb,$mod_strings,$log;
		$log->debug("Entering customer portal function send_mail_for_password");
		$adb->println("Inside the function send_mail_for_password($username).");
	
		$sql = "select * from vtiger_portalinfo  where user_name = ? ";
		$res = $adb->pquery($sql, array($username));
		$user_name = $adb->query_result($res,0,'user_name');
		$password = $adb->query_result($res,0,'user_password');
		$isactive = $adb->query_result($res,0,'isactive');
		$cryptmode = $adb->query_result($res,0,'cryptmode');
		
		//CREATE NEW RANDOM PASSWORD
		//$newpassword = generateStrongPassword();
		
		
		
		if(isset($cryptmode) && $cryptmode!=""){
			$sql = "update vtiger_portalinfo set user_password=?, cryptmode=? where user_name=?";
			$result = $adb->pquery($sql, array(myc_generateEncryptedPassword($newpassword), 'CRYPT', $username));
		}
		else {
			$sql = "update vtiger_portalinfo set user_password=? where user_name=?";
			$result = $adb->pquery($sql, array($newpassword, $username));
		}
		
	
		$contents = myc_translate('LBL_LOGIN_DETAILS');
		$contents .= "<br><br>Username: ".$user_name;
		$contents .= "<br>Password: ".$newpassword;
		//$contents .= "<br>Crypt: ".$cryptmode;
	
		$subject =  myc_translate('LBL_SUBJECT_PORTAL_LOGIN_DETAILS');
			
		if($username == '')
		{
			$ret_msg = "false@@@<b>LBL_GIVE_MAILID-".myc_translate('LBL_GIVE_MAILID')."</b>";
			return array("result"=>"error","error"=>$ret_msg);
		}
		elseif($user_name == '')
		{
			$ret_msg = "false@@@<b>LBL_CHECK_MAILID-".myc_translate('LBL_CHECK_MAILID')."</b>";
			return array("result"=>"error","error"=>$ret_msg);
		}
		elseif($isactive == 0)
		{
			$ret_msg = "false@@@<b>LBL_LOGIN_REVOKED-".myc_translate('LBL_LOGIN_REVOKED')."</b>";
			return array("result"=>"error","error"=>$ret_msg);
		}
		else
		{
			$ret_msg = myc_sendEmail($user_name,$subject,$contents);
		}
	
		$adb->println("Exit from send_mail_for_password. $ret_msg");
		$log->debug("Exiting customer portal function send_mail_for_password");
		return array("result"=>"success");
	}
	
	

	
	function generateStrongPassword($length = 9, $add_dashes = false, $available_sets = 'luds')
	{
		$sets = array();
		if(strpos($available_sets, 'l') !== false)
			$sets[] = 'abcdefghjkmnpqrstuvwxyz';
		if(strpos($available_sets, 'u') !== false)
			$sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
		if(strpos($available_sets, 'd') !== false)
			$sets[] = '23456789';
		if(strpos($available_sets, 's') !== false)
			$sets[] = '!@#$%&*?';
		$all = '';
		$password = '';
		foreach($sets as $set)
		{
			$password .= $set[array_rand(str_split($set))];
			$all .= $set;
		}
		$all = str_split($all);
		for($i = 0; $i < $length - count($sets); $i++)
			$password .= $all[array_rand($all)];
		$password = str_shuffle($password);
		if(!$add_dashes)
			return $password;
		$dash_len = floor(sqrt($length));
		$dash_str = '';
		while(strlen($password) > $dash_len)
		{
			$dash_str .= substr($password, 0, $dash_len) . '-';
			$password = substr($password, $dash_len);
		}
		$dash_str .= $password;
		return $dash_str;
	}
	
	function myc_generateEncryptedPassword($password, $mode='CRYPT') {

		if ($mode == 'MD5') return md5($password);

		if ($mode == 'CRYPT') {
			$salt = null;
			if (function_exists('password_hash')) { // php 5.5+
				$salt = password_hash();
			} else {
				$salt = '$2y$11$'.str_replace("+",".",substr(base64_encode(openssl_random_pseudo_bytes(17)),0,22));
			}
			return crypt($password, $salt);
		}

		throw new Exception('Invalid encryption mode: '.$mode);
	}

	/*
	 * Function to compare encrypted password.
	 */
	function myc_compareEncryptedPassword($plainText, $encryptedPassword, $mode="PLAIN") {
		$reEncryptedPassword = null;
		switch ($mode) {
			case 'CRYPT': $reEncryptedPassword = crypt($plainText, $encryptedPassword); break;
			case 'MD5'  : $reEncryptedPassword = md5($plainText);	break;
			case 'PLAIN':
			default     : $reEncryptedPassword = $plainText;		break;
		}
		return ($reEncryptedPassword == $encryptedPassword);
	}


?>