<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
include_once('vtlib/Vtiger/Event.php');
class MYCExtendedWebServices{

	var $mycextendedws;
	
	public function __construct(){
		
		$this->mycextendedws=array(
			"myc_loginportal" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCLoginPortal.php",
         		"handler_method" => "myc_loginportal",
         		"type" => "POST",
         		"prelogin" => "1",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "username", "type"=>"String"),
         			array("sequence"=>"2", "name" => "password", "type"=>"String"),
         		),
         	),
         	"myc_reset_password" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCLoginPortal.php",
         		"handler_method" => "myc_reset_password",
         		"type" => "POST",
         		"prelogin" => "1",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "username", "type"=>"String"),
         		),
         	),
			"myc_change_password" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCLoginPortal.php",
         		"handler_method" => "myc_change_password",
         		"type" => "POST",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "username", "type"=>"String"),
					array("sequence"=>"2", "name" => "newpassword", "type"=>"String"),
         		),
         	),
         	"myc_ping_ws" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCPortalWS.php",
         		"handler_method" => "myc_ping_ws",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(),
         	),
         	"myc_retrieve_related" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCRetrieveRelated.php",
         		"handler_method" => "myc_retrieve_related",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "id", "type"=>"String"),
         			array("sequence"=>"2", "name" => "relatedType", "type"=>"String"),
         			array("sequence"=>"3", "name" => "relatedLabel", "type"=>"String"),
         		),
         	),
         	"myc_retrieve_related_types" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCRetrieveRelated.php",
         		"handler_method" => "myc_relatedtypes",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "elementType", "type"=>"String"),
         		),
         	),
         	"myc_retrieve_doc_attachment" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCRetrieveDocAttachment.php",
         		"handler_method" => "myc_retrieve_doc_attachment",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "all_ids", "type"=>"String"),
         			array("sequence"=>"2", "name" => "returnfile", "type"=>"String"),
         		),
         	),
         	"myc_create_doc_attachment" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCCreateDocAttachment.php",
         		"handler_method" => "myc_create_doc_attachment",
         		"type" => "POST",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "element", "type"=>"Encoded"),
         		),
         	),
         	"myc_retrieve_translations" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCRetrieveTranslations.php",
         		"handler_method" => "myc_retrieve_translations",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "language", "type"=>"String"),
         			array("sequence"=>"2", "name" => "module", "type"=>"String"),
         		),
         	),
         	"myc_retrieve_languages_list" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCRetrieveTranslations.php",
         		"handler_method" => "myc_retrieve_languages_list",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "dummy", "type"=>"String"),
         		),
         	),
         	"myc_retrieve_module_blocks" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCPortalWS.php",
         		"handler_method" => "myc_retrieve_module_blocks",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "modulename", "type"=>"String"),
         		),
         	),
         	"myc_get_pdf" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCPortalWS.php",
         		"handler_method" => "myc_get_pdf",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "recordid", "type"=>"String"),
         			array("sequence"=>"2", "name" => "module", "type"=>"String"),
         			array("sequence"=>"3", "name" => "language", "type"=>"String"),
         		),
         	),
         	"myc_retrieve_image" => array(
         		"handler_path" => "modules/MYCExtendedWebServices/handlers/MYCPortalWS.php",
         		"handler_method" => "myc_retrieve_image",
         		"type" => "GET",
         		"prelogin" => "0",
         		"operation_params" => array(
         			array("sequence"=>"1", "name" => "recordid", "type"=>"String"),
         			array("sequence"=>"2", "name" => "imagenames", "type"=>"String"),
         		),
         	),
        );
        
	}

	/**
	* Invoked when special actions are performed on the module.
	* @param String Module name
	* @param String Event Type
	*/
	function vtlib_handler($moduleName, $eventType) {
		global $adb;
 		if($eventType == 'module.postinstall') {
			$this->removeMYCWebServices();
			$this->addMYCWebServices();
		} else if($eventType == 'module.enabled') {
			$this->removeMYCWebServices();
			$this->addMYCWebServices();
		} else if($eventType == 'module.disabled') {
			$this->removeMYCWebServices();
		} else if($eventType == 'module.preuninstall') {
			$this->removeMYCWebServices();
		} else if($eventType == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($eventType == 'module.postupdate') {
			$this->removeMYCWebServices();
			$this->addMYCWebServices();
		}
 	}
 	
 	
 	function addMYCWebServices(){
	 	global $adb;
	 	
	 	foreach($this->mycextendedws as $extwsname => $extwsdetail){
		 	$dbwsdetail = $adb->pquery("SELECT * FROM vtiger_ws_operation WHERE name=?;",array($extwsname));
		 	$wsCount =  $adb->num_rows($dbwsdetail);
			if(!isset($wsCount) || $wsCount == 0 || $wsCount == ""){
				$adb->pquery("INSERT INTO vtiger_ws_operation (name,handler_path,handler_method,type,prelogin) VALUES (?,?,?,?,?);", array($extwsname,$extwsdetail['handler_path'],$extwsdetail['handler_method'],$extwsdetail['type'],$extwsdetail['prelogin']));
				
				$newdbwsdetail = $adb->pquery("SELECT * FROM vtiger_ws_operation WHERE name=?;",array($extwsname));
				$newdbwsdetailrow = $adb->query_result_rowdata($newdbwsdetail, 0);	
				
				$adb->pquery("UPDATE vtiger_ws_operation_seq SET id = ?;",array($newdbwsdetailrow["operationid"]));
				//$newoperationrc = $adb->pquery("SELECT id FROM vtiger_ws_operation_seq;");
				//$newoperationrow = $adb->query_result_rowdata($newoperationrc, 0);				
				
				foreach($extwsdetail['operation_params'] as $opparam){
					$adb->pquery("INSERT INTO vtiger_ws_operation_parameters (operationid,name,type,sequence) VALUES (?,?,?,?);", array($newdbwsdetailrow['operationid'],$opparam['name'],$opparam['type'],$opparam['sequence']));
				}
				
			}							
			
		}
 	}
 	
 	function removeMYCWebServices(){
 		global $adb;
	 	foreach($this->mycextendedws as $extwsname => $extwsdetail){
	 		$dbwsdetail = $adb->pquery("SELECT * FROM vtiger_ws_operation WHERE name=?;",array($extwsname));
	 		$wsCount =  $adb->num_rows($dbwsdetail);			
			if(isset($wsCount) && $wsCount > 0 && $wsCount != ""){
				$dbwstoremove = $adb->query_result_rowdata($dbwsdetail, 0);
				$adb->pquery("DELETE FROM vtiger_ws_operation_parameters WHERE operationid = ?;",array($dbwstoremove['operationid']));
				$adb->pquery("DELETE FROM vtiger_ws_operation WHERE name = ?;",array($extwsname));
			}
		 	
	 	}
 	}
}

